/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////


void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = fragCoord.xy / iResolution.xy;
    
    // blur code borrowed from wriggly: https://www.shadertoy.com/view/ld3SW7
    
    fragColor = vec4(0.);
    
    float uvr = 2.*length(uv-.5);
    float v = pow(uvr,2.);
    v = max(v,0.05);
    vec3 bg = .15-.07*vec3(uvr);
    bg.r *= .75;
    bg = vec3(1.);
    
    // crude blur. not quite box, cut off the corners to reduce boxyness
    #define R 3.
    float twt = 0.;
    for( float i = -R; i <= R; i++ )
    {
        for( float j = -R; j <= R; j++ )
        {
            if( abs(i)+abs(j) > 5. ) continue; // corners not welcome
            
            vec4 s = texture2D( iChannel0, uv + 2.*v*vec2(i,j)/iResolution.xy );
            s = smoothstep(0.,.5,s); // blow it out a bit
            
		    fragColor += s;
            twt += 1.;
        }
    }
    fragColor /= twt;
    fragColor *= 2.;
    
    // bg, vign
    fragColor.xyz = .99*vec3(1.,.98,.97) - fragColor.xyz;
    fragColor.xyz *= pow(1. - 1.9*dot(uv-.5,uv-.5),.07);
    // black bars for max drama
    //float yd = min(fragCoord.y,iResolution.y-fragCoord.y);
    //if( yd < 40. ) fragColor *= 0.;
    
    // blemishes
    //fragColor *= .5+.5*smoothstep(0.03,.05,texture2D(iChannel2,uv).x);
    //fragColor *= .7+.3*smoothstep(0.15,.17,texture2D(iChannel2,uv*.3).x);
}

void main ( void )
{
   mainImage ( gl_FragColor, gl_FragCoord.xy );
} 
